/******************************************************************************
                                                   COPYRIGHT (c) Freescale 2005  
                                                                          
File Name          :    $RCSfile: S12PIT24B8CV1.h,v $                     
                                                                          
Current Revision :      $Revision: 1.0 $                                  
                                                                          
PURPOSE: header file for S12X PIT register block.                         
                                                                          
DESCRIPTION:  Defines the PIT register block as a datastructure of type tPIT.       
              
              Access to the channel timer registers is now of the format:
              PIT.ch[n].pitld.word and PIT.ch[n].pitcnt.word
                 
                                                                          
UPDATE HISTORY                                                            
REV  AUTHOR      DATE        DESCRIPTION OF CHANGE                        
---  ------      --------    ---------------------                        
1.0  r32151      01/09/05    Initial Revision based on S12PIT24B4CV1.h.   


     *******************************************************************
     * File created by: Freescale East Kilbride MCD Applications Group *
     *******************************************************************

                                                                          
******************************************************************************/
/*===========================================================================*/
/* Freescale reserves the right to make changes without further notice to any*/
/* product herein to improve reliability, function, or design. Freescale does*/
/* not assume any  liability arising  out  of the  application or use of any */
/* product,  circuit, or software described herein;  neither  does it convey */
/* any license under its patent rights  nor the  rights of others.  Freescale*/
/* products are not designed, intended,  or authorized for use as components */
/* in  systems  intended  for  surgical  implant  into  the  body, or  other */
/* applications intended to support life, or  for any  other application  in */
/* which the failure of the Freescale product  could create a situation where*/
/* personal injury or death may occur. Should Buyer purchase or use Freescale*/
/* products for any such intended  or unauthorized  application, Buyer shall */
/* indemnify and  hold  Freescale  and its officers, employees, subsidiaries,*/
/* affiliates,  and distributors harmless against all claims costs, damages, */
/* and expenses, and reasonable  attorney  fees arising  out of, directly or */
/* indirectly,  any claim of personal injury  or death  associated with such */
/* unintended or unauthorized use, even if such claim alleges that  Freescale*/
/* was negligent regarding the  design  or manufacture of the part. Freescale*/
/* and the Freescale logo* are registered trademarks of Freescale Ltd.       */
/*****************************************************************************/

#ifndef S12PIT24B8CV1_H       /* prevent duplicated includes */
#define S12PIT24B8CV1_H

#include "S12_COMMON.h"

/* General bit masks for PIT channels */
#define PIT_CH0  0x01  
#define PIT_CH1  0x02
#define PIT_CH2  0x04
#define PIT_CH3  0x08
#define PIT_CH4  0x10  
#define PIT_CH5  0x20
#define PIT_CH6  0x40
#define PIT_CH7  0x80

typedef union uPITCFLMT
{
  tU08   byte;
  struct
  {
    tU08 pflmt0  :1;		  /* force load micto timer 0 */
    tU08 pflmt1  :1;		  /* force load micto timer 1 */
    tU08         :3;		  /* not used */
    tU08 pitfrz  :1;		  /* PIT stops in background mode */
    tU08 pitswai :1;		  /* PIT stops in wait mode */
    tU08 pite    :1;		  /* PIT module enable */
  }bit;
} tPITCFLMT;

/* bit masks for PITCFLMT */
#define PFLMT0  0x01   
#define PFLMT1  0x02
#define PITFRZ  0x20
#define PITSWAI 0x40
#define PITE    0x80


typedef union uPITFLT
{
  tU08   byte;
  struct
  {
    tU08 pflt0  :1;		 /* channel timer force loads */ 
    tU08 pflt1  :1;		 
    tU08 pflt2  :1;
    tU08 pflt3  :1;
    tU08 pflt4  :1;		  
    tU08 pflt5  :1;		 
    tU08 pflt6  :1;
    tU08 pflt7  :1;
  } bit;
} tPITFLT;

/* bit masks for PITFLT */
#define PFLT0  0x01  
#define PFLT1  0x02
#define PFLT2  0x04
#define PFLT3  0x08
#define PFLT4  0x10  
#define PFLT5  0x20
#define PFLT6  0x40
#define PFLT7  0x80

typedef union uPITCE
{
  tU08   byte;
  struct
  {
    tU08 pce0   :1;		  /* channel enables */
    tU08 pce1   :1;
    tU08 pce2   :1;
    tU08 pce3   :1;
    tU08 pce4   :1;		  
    tU08 pce5   :1;
    tU08 pce6   :1;
    tU08 pce7   :1;
  } bit;
} tPITCE;

/* bit masks for PITCE */
#define PCE0    0x01  
#define PCE1    0x02
#define PCE2    0x04
#define PCE3    0x08
#define PCE4    0x10  
#define PCE5    0x20
#define PCE6    0x40
#define PCE7    0x80

typedef union uPITMUX
{
  tU08   byte;
  struct
  {
    tU08 pmux0   :1;		  /* channel micro timer selects */
    tU08 pmux1   :1;
    tU08 pmux2   :1;
    tU08 pmux3   :1;
    tU08 pmux4   :1;		  
    tU08 pmux5   :1;
    tU08 pmux6   :1;
    tU08 pmux7   :1;
  } bit;
} tPITMUX;

/* bit masks for PITCE */
#define PMUX0    0x01  
#define PMUX1    0x02
#define PMUX2    0x04
#define PMUX3    0x08
#define PMUX4    0x10  
#define PMUX5    0x20
#define PMUX6    0x40
#define PMUX7    0x80

typedef union uPITINTE
{
  tU08   byte;
  struct
  {
    tU08 pinte0   :1;		  /* channel interrupt enables */
    tU08 pinte1   :1;
    tU08 pinte2   :1;
    tU08 pinte3   :1;
    tU08 pinte4   :1;		  
    tU08 pinte5   :1;
    tU08 pinte6   :1;
    tU08 pinte7   :1;
  } bit;
} tPITINTE;

/* bit masks for PITCE */
#define PINTE0    0x01  
#define PINTE1    0x02
#define PINTE2    0x04
#define PINTE3    0x08
#define PINTE4    0x10  
#define PINTE5    0x20
#define PINTE6    0x40
#define PINTE7    0x80

typedef union uPITTF
{
  tU08   byte;
  struct
  {
    tU08 ptf0   :1;		  /* channel interrupt flags */
    tU08 ptf1   :1;
    tU08 ptf2   :1;
    tU08 ptf3   :1;
    tU08 ptf4   :1;		  
    tU08 ptf5   :1;
    tU08 ptf6   :1;
    tU08 ptf7   :1;
  } bit;
} tPITTF;

/* bit masks for PITTF */
#define PTF0    0x01  
#define PTF1    0x02
#define PTF2    0x04
#define PTF3    0x08
#define PTF4    0x10  
#define PTF5    0x20
#define PTF6    0x40
#define PTF7    0x80

typedef struct 
{
   tREG16 pitld;
   tREG16 pitcnt;
}tPITCH;


typedef struct {           /* pit datastructure */
  volatile tPITCFLMT  pitcflmt;  
  volatile tPITFLT    pitflt; 
  volatile tPITCE     pitce;  
  volatile tPITMUX    pitmux; 
  volatile tPITINTE   pitinte;   
  volatile tPITTF     pittf;  
  volatile tREG08     pitmtld0;
  volatile tREG08     pitmtld1;
  volatile tPITCH     ch[8];
} tPIT;


#endif /*S12PIT24B8CV1_H */